unit EngineImgSelector01;
(*
   ========================================================================
    " " GraphEngine.
          .
   ========================================================================
       TRegionSelector:
   1)       Image.
   2)       Image.
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)

interface
uses
    //  
    Classes, Controls, Types, Graphics, ExtCtrls;

// ------------------------------------------------------------------------
//   -
type TRegionMode = (rmRegionOnly, rmPaintShape);

// ------------------------------------------------------------------------
//      
type TRegionStyle = (dtLine, dtRectangle, dtEllipse, dtRoundRect);

// ------------------------------------------------------------------------
//     
//   TRegionSelector
type TOnSelectEvent = procedure (Sender : TObject; Shift : TShiftState;
                                 BegPoint, EndPoint : TPoint) of object;

// ------------------------------------------------------------------------
//        
type TRegionSelector = class(TObject)
  private
    fImage      : TImage;
    fCanvas     : TCanvas;
    //  
    fSave       : record
      //       fImage
      fMDown      : TMouseEvent;
      fMMove      : TMouseMoveEvent;
      fMUp        : TMouseEvent;
      //   fCanvas
      fBrushStyle : TBrushStyle;
      fBrushColor : TColor;
      fPenMode    : TPenMode;
      fPenStyle   : TPenStyle;
      fPenColor   : TColor;
      fPenWidth   : integer;
    end;
    //     
    fRegionMode  : TRegionMode;   //   
    fRegionStyle : TRegionStyle;  //     
    //   
    fSBuilding    : boolean;       //   
    fSModify      : boolean;       //     
    fSReady       : boolean;       //   
    fVisible      : boolean;       //    
    //   
    fBegPoint     : TPoint;        //   
    fEndPoint     : TPoint;        //   
    fRegion       : TRect;         //  Rect 
    fShape        : TRegionStyle;  //   
    
    //       
    fOnSelectBeg    : TOnSelectEvent;
    fOnSelectChange : TOnSelectEvent;
    fOnSelectEnd    : TOnSelectEvent;
    // ,   Image   Mouse
    procedure SaveMouseEvents();
    procedure RestoreMouseEvents();
    procedure ReSetMouseEvents();
    // ,   Image.Canvas.
    procedure SaveCanvasParm();
    procedure RestoreCanvasParm();
    procedure ReSetCanvasParm();
    //    Mouse
    procedure ImgMouseDown(Sender : TObject; Button : TMouseButton;
                           Shift  : TShiftState; X, Y : Integer);
    procedure ImgMouseUp  (Sender : TObject; Button : TMouseButton;
                           Shift  : TShiftState; X, Y : Integer);
    procedure ImgMouseMove(Sender : TObject;
                           Shift  : TShiftState; X, Y : Integer);

    //     
    procedure DoOnSelectEvent(IdEvent : byte; Shift  : TShiftState);
    //     
    procedure DrawSelectShape (TopLeft, BottomRight : TPoint;
                               RqShape   : TRegionStyle;
                               RqPenMode : TPenMode);
    //     
    procedure PaintHidenRegion(RqPaint : boolean);
  public
    //  -  
    constructor Create(RqImage : TImage);
    procedure Free();
    //    
    procedure ReSetRegionMode(RqRegionMode : TRegionMode);
    //  /    
    procedure RegionVisible(RqVisible : boolean);
    //  
    property RqShape   : TRegionStyle read fRegionStyle write fRegionStyle;
    property Selected  : boolean read fSReady;
    property BegPoint  : TPoint  read fBegPoint;
    property EndPoint  : TPoint  read fEndPoint;
    //      
    property OnSelectBeg    : TOnSelectEvent write fOnSelectBeg;
    property OnSelectChange : TOnSelectEvent write fOnSelectChange;
    property OnSelectEnd    : TOnSelectEvent write fOnSelectEnd;
end;

// ========================================================================
// ========================================================================
implementation
// ========================================================================
// ========================================================================

// ========================================================================
//  
// ========================================================================
//    
function EqualPoints(const P1, P2: TPoint): Boolean;
begin
  Result := (P1.X = P2.X) and (P1.Y = P2.Y);
end;
// -------------------------------------------------------------------
//      
//  ,      
// (Top, Left)  (Bottom, Right).
function NoarmalRect (RqBeg, RqEnd : TPoint) : TRect;
begin
   if RqEnd.X < RqBeg.X
   then  // 1.     - 
      if RqEnd.Y < RqBeg.Y
      then  // 1.1.     - 
         Result := Rect(RqEnd.X, RqEnd.Y, RqBeg.X, RqBeg.Y )
      else  // 1.2.     - 
         Result := Rect(RqEnd.X, RqBeg.Y, RqBeg.X, RqEnd.Y )
   else  // 2     -  ()
      if RqEnd.Y < RqBeg.Y
      then  // 2.1.     - 
         Result := Rect(RqBeg.X, RqEnd.Y, RqEnd.X, RqBeg.Y )
      else  // 2.2.     -  ()
         Result := Rect(RqBeg.X, RqBeg.Y, RqEnd.X, RqEnd.Y );
end; // of function

// ========================================================================
//      TRegionSelector
// ========================================================================
//  
constructor TRegionSelector.Create(RqImage : TImage);
begin
  if Assigned(RqImage)
  then begin
     inherited Create();
     fImage  := RqImage;
     fCanvas := fImage.Canvas;
     SaveMouseEvents();
     ReSetMouseEvents();
     fSReady := False;
     fRegionMode  := rmRegionOnly;
     fRegionStyle := dtRectangle;
     fVisible  := True;
  end;
end;
// ------------------------------------------------------------------------
//   
procedure TRegionSelector.Free();
begin
  if Assigned(fImage)
  then begin
     RestoreMouseEvents();
     inherited Free();
  end;
end;

// ========================================================================
// ,   Image  Mouse .
//  Image  Mouse    .
//      
// ========================================================================
//   Image  Mouse 
procedure TRegionSelector.SaveMouseEvents();
begin
  with fSave do
  begin
    fMDown := fImage.OnMouseDown;
    fMMove := fImage.OnMouseMove;
    fMUp   := fImage.OnMouseUp;
  end;
end;
// ------------------------------------------------------------------------
//   Image  Mouse 
procedure TRegionSelector.RestoreMouseEvents();
begin
  with fSave do
  begin
    fImage.OnMouseDown  := fMDown;
    fImage.OnMouseMove  := fMMove;
    fImage.OnMouseUp    := fMUp;
  end;
end;
// ------------------------------------------------------------------------
//   Image   Mouse 
procedure TRegionSelector.ReSetMouseEvents();
begin
  fImage.OnMouseDown  := Self.ImgMouseDown;
  fImage.OnMouseMove  := Self.ImgMouseMove;
  fImage.OnMouseUp    := Self.ImgMouseUp;
end;
// ------------------------------------------------------------------------
//       
procedure TRegionSelector.DoOnSelectEvent(IdEvent : byte;
          Shift  : TShiftState);
begin
  case IdEvent of
  1 : begin //   
        if Assigned(fOnSelectBeg)
        then begin
           //   Image.Canvas .
           RestoreCanvasParm();
           try fOnSelectBeg (Self, Shift, fBegPoint, fEndPoint);
           except //   
              fOnSelectBeg := nil;
           end;
           //   Brush  Pen    .
           ReSetCanvasParm();
        end;
      end;
  2 : begin //    
        if Assigned(fOnSelectChange)
        then begin
           //   Image.Canvas .
           RestoreCanvasParm();
           try fOnSelectChange (Self, Shift, fBegPoint, fEndPoint);
           except //   
              fOnSelectChange := nil;
           end;
           //   Brush  Pen    .
           ReSetCanvasParm();
        end;
      end;
  3 : begin //   
        if Assigned(fOnSelectEnd)
        then begin
           //   Image.Canvas .
           RestoreCanvasParm();
           try fOnSelectEnd (Self, Shift, fBegPoint, fEndPoint);
           except //   
              fOnSelectEnd := nil;
           end;
           //   Brush  Pen    .
           ReSetCanvasParm();
        end;
     end;
  end; // of case
end;

// ========================================================================
// , ,   Image.Canvas
// .
// ========================================================================
//   Brush  Pen
procedure TRegionSelector.SaveCanvasParm();
begin
  with fImage.Canvas do
  begin
    fSave.fBrushStyle := Brush.Style;
    fSave.fBrushColor := Brush.Color;
    fSave.fPenMode    := Pen.Mode;
    fSave.fPenStyle   := Pen.Style;
    fSave.fPenColor   := Pen.Color;
    fSave.fPenWidth   := Pen.Width;
  end;
end;
// ------------------------------------------------------------------------
//   Brush  Pen
procedure TRegionSelector.RestoreCanvasParm();
begin
  with fImage.Canvas do
  begin
    Brush.Style := fSave.fBrushStyle;
    Brush.Color := fSave.fBrushColor;
    Pen.Mode    := fSave.fPenMode;
    Pen.Style   := fSave.fPenStyle;
    Pen.Color   := fSave.fPenColor;
    Pen.Width   := fSave.fPenWidth;
  end;
end;
// ------------------------------------------------------------------------
//   Brush  Pen
procedure TRegionSelector.ReSetCanvasParm();
begin
  with fImage.Canvas do
  begin
    Brush.Style := bsClear;
    Brush.Color := clWhite;
    Pen.Style   := psSolid;
    Pen.Mode    := pmNotXor;
    Pen.Color   := clBlack;
    Pen.Width   := 1;
  end;
end;

// ========================================================================
//    .
// , ,      .
// ========================================================================
//    .
procedure TRegionSelector.DrawSelectShape(TopLeft, BottomRight : TPoint;
                                          RqShape   : TRegionStyle;
                                          RqPenMode : TPenMode);
begin
  with fCanvas do
  begin
    Pen.Mode := RqPenMode;
    case RqShape of
      dtLine:
         begin
           MoveTo(TopLeft.X, TopLeft.Y);
           LineTo(BottomRight.X, BottomRight.Y);
         end;
      dtRectangle:
           Rectangle(TopLeft.X, TopLeft.Y, BottomRight.X, BottomRight.Y);
      dtEllipse:
           Ellipse(Topleft.X, TopLeft.Y, BottomRight.X, BottomRight.Y);
      dtRoundRect:
           RoundRect(TopLeft.X, TopLeft.Y, BottomRight.X,
                     BottomRight.Y, (TopLeft.X - BottomRight.X) div 2,
                     (TopLeft.Y - BottomRight.Y) div 2);
    end;
  end;
end;
// ------------------------------------------------------------------------
//      
procedure TRegionSelector.ImgMouseDown(Sender: TObject;
          Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Shift = [ssLeft]
  then begin
     SaveCanvasParm();            //   .
     ReSetCanvasParm();           //   .
     if fSReady and fVisible
     then begin
        fCanvas.Pen.Style := psDot;
        //     
        DrawSelectShape(fBegPoint, fEndPoint, fShape, pmNotXor);
        fVisible := False;
     end;
     fSBuilding := True;          //   
     fSReady    := False;         //    
     fSModify   := False;         //     
     fCanvas.MoveTo(X, Y);
     fBegPoint := Point(X, Y);
     fEndPoint := fBegPoint;
     //    
     DoOnSelectEvent(1, Shift);
  end;
end;
// ------------------------------------------------------------------------
//       
procedure TRegionSelector.ImgMouseMove(Sender: TObject;
          Shift: TShiftState; X, Y: Integer);
begin
  if fSBuilding   //    
  then begin
     //    ,     
     if fSModify then DrawSelectShape(fBegPoint, fEndPoint,
                                      fRegionStyle, pmNotXor);
     fEndPoint := Point(X, Y);
     //     
     fSModify := fSModify
              or (fEndPoint.X <> fBegPoint.X)
              or (fEndPoint.Y <> fBegPoint.Y);
     if fSModify
     then begin
        //     
        DrawSelectShape(fBegPoint, fEndPoint, fRegionStyle, pmNotXor);
        //    
        DoOnSelectEvent(2, Shift);
     end;
  end;
end;
// ------------------------------------------------------------------------
//     
procedure TRegionSelector.ImgMouseUp(Sender: TObject;
          Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if fSBuilding               //    
  then begin
    fSBuilding := False;      //    
    if fSModify               //    (  )
    then begin
       //     
       DrawSelectShape(fBegPoint, fEndPoint, fRegionStyle, pmNotXor);
       fSModify := False;     //   
       if fRegionMode = rmRegionOnly
       then begin
          //     
          fCanvas.Pen.Style := psDot;
          DrawSelectShape(fBegPoint, fEndPoint, fRegionStyle, pmNotXor);
          fVisible := True;
       end;
    end;
    //   Rectangle 
    fRegion := NoarmalRect(fBegPoint, fEndPoint);
    fShape  := fRegionStyle;   //    
    fSReady := True;           //  
    //    
    DoOnSelectEvent(3, Shift);
    //     Brush, Pen.
    RestoreCanvasParm();
  end;
end;
// ------------------------------------------------------------------------
//     
procedure TRegionSelector.PaintHidenRegion(RqPaint : boolean);
begin
   fCanvas.Pen.Style := psDot;
   if RqPaint
   then begin //  -    Image
        //     
        if (not EqualPoints(fBegPoint, fEndPoint)) and (not fVisible)
        then //    
             DrawSelectShape(fBegPoint, fEndPoint, fShape, pmNotXor);
        fVisible  := True;    //     Image
   end
   else begin //  -    Image
        //     
        if (not EqualPoints(fBegPoint, fEndPoint)) and fVisible
        then //    
             DrawSelectShape(fBegPoint, fEndPoint, fShape, pmNotXor);
        fVisible  := False;   //     Image
   end;
end;
// ------------------------------------------------------------------------
//    
procedure TRegionSelector.ReSetRegionMode(RqRegionMode : TRegionMode);
begin
 if fRegionMode <> RqRegionMode
 then begin
    SaveCanvasParm();
    ReSetCanvasParm();
    case RqRegionMode of
      rmRegionOnly : PaintHidenRegion(True);
      rmPaintShape : PaintHidenRegion(False);
    end;
    //     
    fRegionMode := RqRegionMode;
    RestoreCanvasParm();
 end;
end;
// ------------------------------------------------------------------------
//  /    
procedure TRegionSelector.RegionVisible(RqVisible : boolean);
begin
   if fRegionMode = rmRegionOnly
   then begin
      SaveCanvasParm();
      ReSetCanvasParm();
      PaintHidenRegion(RqVisible);
      RestoreCanvasParm();
   end;
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.

